<?php
/* --------------------------------------------------------------
  Repository.php 2020-02-21
  Gambio GmbH
  http://www.gambio.de
  Copyright (c) 2020 Gambio GmbH
  Released under the GNU General Public License (Version 2)
  [http://www.gnu.org/licenses/gpl-2.0.html]
  --------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Shop\Properties\SellingUnitEan\Repository;

use Gambio\Shop\Properties\SellingUnitEan\Repository\Dto\CombiIdDto;
use Gambio\Shop\Properties\SellingUnitEan\Repository\Dto\EanDto;
use Gambio\Shop\Properties\SellingUnitEan\Repository\Reader\ReaderInterface;

/**
 * Class Repository
 * @package Gambio\Shop\Properties\SellingUnitEan\Repository
 */
class Repository implements RepositoryInterface
{
    
    /**
     * @var ReaderInterface
     */
    protected $reader;
    
    
    public function __construct(ReaderInterface $reader)
    {
        $this->reader = $reader;
    }
    
    
    /**
     * @inheritDoc
     */
    public function getEanValueByPropertyCombination(CombiIdDto $combiIdDto) : EanDto
    {
        $ean = $this->reader->getEanValueByCombiId($combiIdDto->value());
        
        return new EanDto($ean);
    }
}